-----------------------------------------------------------------------
--
--  MISE A JOUR DE LA STRUCTURE DE LA TABLE ImportHistory
--
-----------------------------------------------------------------------

/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/

CREATE TABLE dbo.Tmp_ImportHistory
	(
	IHNumber int NOT NULL,
	IHDateTime datetime NULL,
	IHFileName varchar(255) NULL,
	IHStartQuest nvarchar(10) NULL,
	IHEndQuest nvarchar(10) NULL,
	IHStartNumber bigint NULL,
	IHEndNumber bigint NULL,
	projectId int NULL,
	modifiedBy int NULL
	)  ON [PRIMARY]
GO
IF EXISTS(SELECT * FROM dbo.ImportHistory)
	 EXEC('INSERT INTO dbo.Tmp_ImportHistory (IHNumber, IHDateTime, IHFileName, IHStartQuest, IHEndQuest, IHStartNumber, IHEndNumber, projectId, modifiedBy)
		SELECT IHNumber, IHDateTime, IHFileName, IHStartQuest, IHEndQuest, CONVERT(bigint, IHStartNumber), CONVERT(bigint, IHEndNumber), projectId, modifiedBy FROM dbo.ImportHistory WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.ImportHistory
GO
EXECUTE sp_rename N'dbo.Tmp_ImportHistory', N'ImportHistory', 'OBJECT' 
GO
ALTER TABLE dbo.ImportHistory ADD CONSTRAINT
	PK_ImportHistory PRIMARY KEY CLUSTERED 
	(
	IHNumber
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO


